﻿//////////////////////////////////////////////
// BitStream.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkMemory
#include "../Dll/DllDefines.h"

#include "../Containers/BufferView.h"

/// Class ------------------------------------

namespace nkMemory
{
	class DLL_MEMORY_EXPORT BitStream
	{
		public :

			// Constructor, destructor
			BitStream (BufferView<> data) noexcept ;

			// Getters
			BufferView<> getData () const ;
			unsigned char getCurrentByte () const ;
			unsigned int getByteCounter () const ;
			unsigned int getBitCounter () const ;
			bool isAtEos () const ;

			// Controls
			unsigned int peekMsb (unsigned int count) ;
			unsigned int peekLsb (unsigned int count) ;
			unsigned int readMsb (unsigned int count) ;
			unsigned int readLsb (unsigned int count) ;
			void moveForward (unsigned int count) ;
			void moveToNextByte () ;
			void moveTo (unsigned int byteCount, unsigned int bitCount) ;
			void rewind () ;

		private :

			// Data
			unsigned char* _data ;
			unsigned int _size ;

			// Tracking
			unsigned int _byteCounter ;
			unsigned int _bitCounter ;
	} ;
}